DROP PROCEDURE [hips].[PatientMasterNameUpdate]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew
-- Create date: 18 October 2012
-- Description:   Updates an existing record in the Patient Master Names Table
-- =============================================
CREATE PROCEDURE [hips].[PatientMasterNameUpdate] 
(
       @PatientMasterNameId INT
      ,@PatientMasterId INT
      ,@TitleId INT = NULL
      ,@GivenNames VARCHAR(80)
      ,@FamilyName VARCHAR(80)
      ,@SuffixId VARCHAR(80) = NULL
      ,@NameTypeId INT
	  ,@UserModified VARCHAR(256)
	  ,@DateModified datetime
)
AS
BEGIN
    SET NOCOUNT ON
 DECLARE @intErrorCode int

    SET @intErrorCode = 0

    IF NOT EXISTS (SELECT TOP 1 [DateModified]
            	FROM [hips].[PatientMasterName]
				WHERE [PatientMasterNameId] = @PatientMasterNameId AND [DateModified] = @DateModified)
    BEGIN
        RAISERROR 50001 'Record has already been updated!'
        SET @intErrorCode = @@ERROR
    END
 IF @intErrorCode = 0
    BEGIN
        UPDATE [hips].[PatientMasterName]
           SET [PatientMasterId] = @PatientMasterId
			  ,[TitleId] = @TitleId
			  ,[GivenNames] = @GivenNames
			  ,[FamilyName] = @FamilyName
			  ,[SuffixId] = @SuffixId
			  ,[NameTypeId] = @NameTypeId
             , [DateModified] = GetDate()
             , [UserModified] = @UserModified
         WHERE [PatientMasterNameID] = @PatientMasterNameID

        SELECT @intErrorCode = @@ERROR
    END

    IF @intErrorCode = 0
    BEGIN
       SELECT   pmn.PatientMasterNameId,
				pmn.PatientMasterId,
				pmn.TitleId,
				t.Description AS Title,
				pmn.GivenNames,
				pmn.FamilyName,
				pmn.SuffixId,
				s.Description AS Suffix,
				pmn.NameTypeId,
				nt.Description AS NameType,
				pmn.DateCreated,
				pmn.UserCreated,
				pmn.DateModified,
				pmn.UserModified
		FROM  hips.PatientMasterName pmn
		LEFT OUTER JOIN hips.Title AS t ON t.TitleId = pmn.TitleId
		LEFT OUTER JOIN hips.Suffix AS s ON s.SuffixId = pmn.SuffixId
		LEFT OUTER JOIN hips.NameType AS nt ON nt.NameTypeId = pmn.NameTypeId
		WHERE pmn.PatientMasterNameId = @PatientMasterNameId
    END

    RETURN(@intErrorCode)

END
GO

